/*
 * Decompiled with CFR 0.152.
 */
package cuscribe_0_1;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import cuscribe_0_1.MainWindow;
import cuscribe_0_1.UIUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Serial
implements Runnable {
    public final int sendFileCommand = 0;
    public final int sendResetCuScribe = 1;
    public final int homeCommand = 2;
    public final int sendGcodeCommand = 3;
    public final int clearAlarmCommand = 4;
    public final int setHeightCommand = 5;
    public final int resetZeroCommand = 6;
    public final int jogCommand = 7;
    public final int disconnectCommand = 8;
    public final int calibrateCommand = 9;
    public final int probeCommand = 10;
    public final int settingsUpdateCommand = 11;
    static int GRBL_BUFFER_SIZE = 125;
    static MainWindow mainWindow;
    static Boolean connected;
    SerialPort serialPort;
    BlockingQueue<Integer> commandComplete = null;
    GrblSerialSender sender = null;
    GrblSerialListener listener = null;
    UIUpdater uiupdater;
    int command = 0;
    boolean pause = false;
    boolean cancel = false;
    boolean commandPending = false;
    long lastPing = 0L;
    long connectedTime = 0L;
    long connectingStarted = 0L;
    boolean sendingStatus = false;
    boolean first = true;
    String commPort = null;
    Integer baud = null;

    @Override
    public void run() {
        while (true) {
            if (this.commandPending) {
                switch (this.command) {
                    case 0: {
                        this.pause = false;
                        this.cancel = false;
                        Serial.mainWindow.enableScreen = false;
                        mainWindow.toggleButtons(false);
                        mainWindow.setPrintingButtons();
                        this.sendFile();
                        mainWindow.toggleButtons(true);
                        Serial.mainWindow.enableScreen = true;
                        this.pause = false;
                        this.cancel = false;
                        this.commandPending = false;
                        break;
                    }
                    case 2: {
                        this.home();
                        this.sendGcode("G20G91G0Y-.1F1000");
                        this.sendGcode("G10 P0 L20 X0 Y0 Z0");
                        this.commandPending = false;
                        break;
                    }
                    case 3: {
                        this.sendGcode(mainWindow.getGcodeInput());
                        this.commandPending = false;
                        break;
                    }
                    case 4: {
                        this.sendGcode("$X");
                        this.commandPending = false;
                        break;
                    }
                    case 5: {
                        this.sendGcode("$H");
                        this.sendGcode("G10 P0 L20 X0 Y0 Z0");
                        this.sendGcode("G20G91G0X2.25F1000");
                        this.sendGcode("G20G91G0Z-0.35F1000");
                        this.commandPending = false;
                        break;
                    }
                    case 6: {
                        this.sendGcode("G10 P0 L20 X0 Y0 Z0");
                        this.commandPending = false;
                        break;
                    }
                    case 7: {
                        this.sendGcode(mainWindow.getJogCommand());
                        this.commandPending = false;
                        break;
                    }
                    case 8: {
                        this.connectingStarted = Long.MAX_VALUE;
                        mainWindow.disconnect();
                        this.commandPending = false;
                        break;
                    }
                    case 9: {
                        mainWindow.setWait();
                        this.home();
                        this.sendGcode("G20G91G0Y2F1000");
                        this.sendGcode("G20G91G0X0.2F1000");
                        this.sendGcode("G20G91G0Z-0.35F1000");
                        mainWindow.calibrateStep2();
                        break;
                    }
                    case 10: {
                        mainWindow.setWait();
                        this.listener.probeXLeft = 0.0;
                        this.listener.probeXRight = 0.0;
                        this.listener.probing = true;
                        this.sendGcode("$$");
                        this.sendGcode("G20G38.2X-15F1");
                        this.sendGcode("G20G91G0X4.25F1000");
                        this.sendGcode("G20G38.2X5F1");
                        this.updateProbeSettings();
                        this.listener.probing = false;
                        this.commandPending = false;
                        break;
                    }
                    case 11: {
                        mainWindow.setWait();
                        this.updateSettings();
                        this.commandPending = false;
                    }
                }
                mainWindow.stopWait();
            } else if (connected.booleanValue()) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastPing > 1000L && currentTime - this.connectedTime > 5000L && this.serialPort != null && this.serialPort.isOpen() && connected.booleanValue()) {
                    this.sendingStatus = true;
                    this.sendGcode("?");
                    this.sendingStatus = false;
                    this.lastPing = currentTime;
                }
            } else if (System.currentTimeMillis() - this.connectingStarted > 7000L && !connected.booleanValue()) {
                this.connectingStarted = Long.MAX_VALUE;
                mainWindow.setConnectButtonText("Connect");
                mainWindow.setConnectLabelText("Connect fail.");
                mainWindow.stopWait();
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (Exception e) {
                System.out.println("run_exception");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings() {
        File f = new File(Serial.mainWindow.settingsFile);
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(f));
            while ((sCurrentLine = br.readLine()) != null) {
                this.sendGcode(sCurrentLine);
                Thread.sleep(200L);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void connect(SerialPort port) throws IOException, InterruptedException {
        if (connected.booleanValue()) {
            this.connectingStarted = Long.MAX_VALUE;
            connected = false;
            this.sender.completedCommands.clear();
            this.serialPort.removeDataListener();
            this.serialPort.closePort();
            mainWindow.setConnectButtonText("Connect");
            mainWindow.toggleButtons(false);
            mainWindow.setDisconnectedButtons();
            mainWindow.stopWait();
        } else {
            this.connectedTime = Long.MAX_VALUE;
            this.connectingStarted = Long.MAX_VALUE;
            mainWindow.setWait();
            this.serialPort = port;
            if (this.sender == null) {
                this.sender = new GrblSerialSender(this.serialPort, this.commandComplete, GRBL_BUFFER_SIZE);
            } else {
                this.sender.clearSender();
            }
            if (this.listener == null) {
                this.listener = new GrblSerialListener(this.serialPort, this.commandComplete);
            }
            this.serialPort.addDataListener(this.listener);
            this.connectingStarted = System.currentTimeMillis();
            this.serialPort.openPort();
            this.serialPort.setBaudRate(115200);
            this.serialPort.setComPortParameters(115200, 8, 1, 0);
        }
    }

    public void home() {
        this.sendGcode("$H");
    }

    public void updateProbeSettings() {
        double stepsMM = this.listener.xStepPerMM * (this.listener.probeXRight - this.listener.probeXLeft) / 111.125;
        double pulloffMM = this.listener.xStepPerMM * (this.listener.probeXLeft - 1.5875) / stepsMM;
        DecimalFormat dfThreeDwecimal = new DecimalFormat("#.###");
        dfThreeDwecimal.setRoundingMode(RoundingMode.HALF_UP);
        System.out.println(dfThreeDwecimal.format(stepsMM));
        System.out.println(dfThreeDwecimal.format(pulloffMM));
        this.sendGcode("$100=" + dfThreeDwecimal.format(stepsMM));
        this.sendGcode("$27=" + dfThreeDwecimal.format(pulloffMM));
        this.uiupdater.receivedLog("Steps per MM new: " + dfThreeDwecimal.format(stepsMM) + "\n");
        this.uiupdater.receivedLog("Pulloff MM new: " + dfThreeDwecimal.format(pulloffMM) + "\n");
    }

    public void sendGcode(String gcode) {
        try {
            this.sender.sendLineBlocking(gcode);
        }
        catch (Exception e) {
            System.out.println("sendGcode: " + e.toString());
        }
    }

    public void sendFile() {
        File f = new File(mainWindow.getFileLocation());
        this.sender.sendFile(f);
    }

    public Serial(MainWindow _main, UIUpdater _uiupdater) {
        mainWindow = _main;
        this.commandComplete = new LinkedBlockingQueue<Integer>();
        this.uiupdater = _uiupdater;
        this.connectedTime = Long.MAX_VALUE;
        this.connectingStarted = Long.MAX_VALUE;
    }

    static {
        connected = false;
    }

    private class GrblSerialSender {
        File file = null;
        String gcode = null;
        SerialPort port = null;
        Integer currentBufferSize = null;
        Integer maxBufferSize = null;
        BlockingQueue<Integer> completedCommands = null;
        LinkedList<Integer> activeCommandSizes;

        private GrblSerialSender(SerialPort sp, BlockingQueue<Integer> _completedCommands, Integer activeBufferSize) {
            this.port = sp;
            this.maxBufferSize = activeBufferSize;
            this.currentBufferSize = 0;
            this.completedCommands = _completedCommands;
            this.activeCommandSizes = new LinkedList();
        }

        private void clearSender() {
            this.completedCommands.clear();
            this.activeCommandSizes.clear();
            this.currentBufferSize = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendFile(File file) {
            Serial.this.sender.clearSender();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                while (true) {
                    String sCurrentLine;
                    if ((sCurrentLine = br.readLine()) == null) {
                        while (this.currentBufferSize > 0) {
                            this.completedCommands.take();
                            this.currentBufferSize = this.currentBufferSize - this.activeCommandSizes.removeFirst();
                            Thread.sleep(100L);
                        }
                        return;
                    }
                    while (Serial.this.pause) {
                        if (Serial.this.cancel) {
                            return;
                        }
                        Thread.sleep(500L);
                    }
                    if (Serial.this.cancel) {
                        return;
                    }
                    this.sendLine(sCurrentLine);
                }
            }
            catch (Exception exception) {
                return;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        private void sendLine(String s) {
            if (!Serial.this.sendingStatus || Serial.this.sendingStatus && mainWindow.getVerbose()) {
                Serial.this.uiupdater.receivedLog(">>" + s + "\n");
            }
            while (this.maxBufferSize < this.currentBufferSize + s.length() + 1) {
                try {
                    this.completedCommands.take();
                    this.currentBufferSize = this.currentBufferSize - this.activeCommandSizes.removeFirst();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Serial.class.getName()).log(Level.SEVERE, null, ex);
                    return;
                }
            }
            try {
                int commandSize = s.length() + 1;
                String stCommand = s.trim() + "\n";
                this.port.writeBytes(stCommand.getBytes(), commandSize);
                this.activeCommandSizes.add(commandSize);
                this.currentBufferSize = this.currentBufferSize + commandSize;
            }
            catch (Exception ex) {
                System.out.println("sendLine: " + ex.toString());
                Logger.getLogger(Serial.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }

        private void sendLineBlocking(String s) {
            if (mainWindow.getVerbose() || !Serial.this.sendingStatus) {
                Serial.this.uiupdater.receivedLog(">>" + s + "\n");
            }
            try {
                int commandSize = s.length() + 1;
                String stCommand = s.trim() + "\n";
                this.port.writeBytes(stCommand.getBytes(), commandSize);
                this.activeCommandSizes.add(commandSize);
                this.currentBufferSize = this.currentBufferSize + commandSize;
            }
            catch (Exception ex) {
                System.out.println("sendLineBlocking: " + ex.toString());
                Logger.getLogger(Serial.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            try {
                this.completedCommands.take();
                this.currentBufferSize = this.currentBufferSize - this.activeCommandSizes.removeFirst();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Serial.class.getName()).log(Level.SEVERE, null, ex);
                System.out.println("sendLineBlocking2: " + ex.toString());
                return;
            }
        }
    }

    private class GrblSerialListener
    implements SerialPortDataListener {
        SerialPort serialPort = null;
        BlockingQueue<Integer> completedCommands;
        StringBuilder inputBuffer;
        double probeXLeft = 0.0;
        double probeXRight = 0.0;
        double xMaxTravel = 0.0;
        double homingPulloff = 0.0;
        double xStepPerMM = 0.0;
        boolean probing = false;

        private GrblSerialListener(SerialPort port, BlockingQueue<Integer> completedCommands) {
            this.serialPort = port;
            this.completedCommands = completedCommands;
            this.inputBuffer = new StringBuilder();
        }

        @Override
        public int getListeningEvents() {
            return 1;
        }

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (1 == event.getEventType()) {
                if (!connected.booleanValue()) {
                    mainWindow.toggleButtons(true);
                    connected = true;
                    mainWindow.setConnectButtonText("Disconnect");
                    Serial.this.connectedTime = System.currentTimeMillis();
                    mainWindow.stopWait();
                }
                try {
                    byte[] buffer = new byte[this.serialPort.bytesAvailable()];
                    int numRead = this.serialPort.readBytes(buffer, buffer.length);
                    for (byte b : buffer) {
                        if (b == 10) {
                            String inputBuff = this.inputBuffer.toString();
                            boolean isOk = inputBuff.startsWith("ok");
                            if (!Serial.this.sendingStatus || !isOk || mainWindow.getVerbose()) {
                                Serial.this.uiupdater.receivedLog(inputBuff + "\n");
                            }
                            if (inputBuff.startsWith("[Reset to continue]")) {
                                Serial.this.commandPending = true;
                                Serial.this.command = 8;
                                this.completedCommands.add(1);
                            }
                            if (isOk || inputBuff.startsWith("error")) {
                                this.completedCommands.add(1);
                            }
                            if (this.probing) {
                                if (inputBuff.startsWith("[PRB:")) {
                                    this.getProbeValues(inputBuff);
                                } else if (inputBuff.startsWith("$130=")) {
                                    this.xMaxTravel = Float.parseFloat(inputBuff.substring(5, inputBuff.indexOf(" (")));
                                } else if (inputBuff.startsWith("$27=")) {
                                    this.homingPulloff = Float.parseFloat(inputBuff.substring(4, inputBuff.indexOf(" (")));
                                } else if (inputBuff.startsWith("$100=")) {
                                    this.xStepPerMM = Float.parseFloat(inputBuff.substring(5, inputBuff.indexOf(" (")));
                                }
                            }
                            this.inputBuffer.setLength(0);
                            continue;
                        }
                        this.inputBuffer.append((char)b);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex);
                    System.out.println("serialEvent");
                }
            }
        }

        public void getProbeValues(String inputBuff) {
            int indexPos = inputBuff.indexOf("[PRB");
            int posComma = inputBuff.indexOf(",", indexPos);
            String xString = inputBuff.substring(indexPos + 5, posComma);
            int posComma2 = inputBuff.indexOf(",", posComma + 1);
            String yString = inputBuff.substring(posComma + 1, posComma2);
            int posColon = inputBuff.indexOf(":", posComma2 + 1);
            String zString = inputBuff.substring(posComma2 + 1, posColon);
            if (this.probeXLeft == 0.0) {
                this.probeXLeft = Serial.this.listener.xMaxTravel + Double.parseDouble(xString) * 25.4;
            } else {
                this.probeXRight = Serial.this.listener.xMaxTravel + Double.parseDouble(xString) * 25.4;
            }
        }
    }
}

