/*
 * Decompiled with CFR 0.152.
 */
package cuscribe_0_1;

import com.fazecast.jSerialComm.SerialPort;
import cuscribe_0_1.Serial;
import cuscribe_0_1.UIUpdater;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultCaret;

public class MainWindow
extends JFrame {
    Serial s;
    Boolean enableScreen = true;
    UIUpdater uiupdater;
    Serial sp;
    SerialPort[] ports;
    String settingsFile;
    ArrayList<JButton> buttons = new ArrayList();
    String jogCommand = "";
    private JButton calibrate;
    private JButton cancel;
    private JButton clearAlarm;
    private JButton connect;
    private JLabel connectLabel;
    private JTextField feedRate;
    private JLabel fileLabel;
    private JTextField gcodeInput;
    private JButton home;
    private JRadioButton inRadio;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton load;
    private JRadioButton mmRadio;
    private JButton pause;
    private JLabel positionLabel;
    private JTextArea receivedTextArea;
    private JButton refresh;
    private JButton resetZero;
    private JButton sendGcode;
    private JComboBox<String> serialDropdown;
    private JButton setHeight;
    private JButton settings;
    private JButton start;
    private JRadioButton verbose;
    private JButton xLeft;
    private JButton xRight;
    private JTextField xyStep;
    private JButton yDown;
    private JButton yUp;
    private JButton zDown;
    private JTextField zStep;
    private JButton zUp;

    public MainWindow() {
        this.uiupdater = new UIUpdater();
        Thread t_ui = new Thread(this.uiupdater);
        t_ui.start();
        this.s = new Serial(this, this.uiupdater);
        Thread t = new Thread(this.s);
        t.start();
        this.initComponents();
        DefaultCaret caret = (DefaultCaret)this.receivedTextArea.getCaret();
        caret.setUpdatePolicy(2);
        this.addButtonsToList();
        this.uiupdater.setMainWindow(this);
        this.updateSerialPorts();
        this.toggleButtons(false);
        this.setDisconnectedButtons();
    }

    public JTextArea getReceivedTextArea() {
        return this.receivedTextArea;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.serialDropdown = new JComboBox();
        this.refresh = new JButton();
        this.jPanel2 = new JPanel();
        this.yUp = new JButton();
        this.yDown = new JButton();
        this.xLeft = new JButton();
        this.xRight = new JButton();
        this.zUp = new JButton();
        this.zDown = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.xyStep = new JTextField();
        this.zStep = new JTextField();
        this.resetZero = new JButton();
        this.clearAlarm = new JButton();
        this.inRadio = new JRadioButton();
        this.mmRadio = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.feedRate = new JTextField();
        this.settings = new JButton();
        this.gcodeInput = new JTextField();
        this.sendGcode = new JButton();
        this.connect = new JButton();
        this.jLabel5 = new JLabel();
        this.setHeight = new JButton();
        this.jLabel6 = new JLabel();
        this.home = new JButton();
        this.start = new JButton();
        this.pause = new JButton();
        this.cancel = new JButton();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.load = new JButton();
        this.connectLabel = new JLabel();
        this.fileLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.receivedTextArea = new JTextArea();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.positionLabel = new JLabel();
        this.calibrate = new JButton();
        this.verbose = new JRadioButton();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setAutoRequestFocus(false);
        this.setBackground(Color.white);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setFont(new Font("Tahoma", 0, 18));
        this.jLabel1.setFont(new Font("Tahoma", 0, 18));
        this.jLabel1.setText("Connect Serial Port");
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/cuscribe/images/cuscribe.png")));
        this.serialDropdown.setFont(new Font("Tahoma", 0, 18));
        this.serialDropdown.setPreferredSize(new Dimension(99, 40));
        this.refresh.setFont(new Font("Tahoma", 0, 18));
        this.refresh.setText("Refresh");
        this.refresh.setMargin(new Insets(12, 10, 12, 15));
        this.refresh.setMaximumSize(new Dimension(99, 60));
        this.refresh.setMinimumSize(new Dimension(99, 60));
        this.refresh.setPreferredSize(new Dimension(89, 24));
        this.refresh.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.refreshMouseClicked(evt);
            }
        });
        this.jPanel2.setBackground(new Color(237, 237, 237));
        this.yUp.setFont(new Font("Tahoma", 0, 24));
        this.yUp.setText("Y+");
        this.yUp.setToolTipText("");
        this.yUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.yUpMouseClicked(evt);
            }
        });
        this.yDown.setFont(new Font("Tahoma", 0, 24));
        this.yDown.setText("Y-");
        this.yDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.yDownMouseClicked(evt);
            }
        });
        this.yDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.yDownActionPerformed(evt);
            }
        });
        this.xLeft.setFont(new Font("Tahoma", 0, 24));
        this.xLeft.setText("X-");
        this.xLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.xLeftMouseClicked(evt);
            }
        });
        this.xRight.setFont(new Font("Tahoma", 0, 24));
        this.xRight.setText("X+");
        this.xRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.xRightMouseClicked(evt);
            }
        });
        this.zUp.setFont(new Font("Tahoma", 0, 24));
        this.zUp.setText("Z+");
        this.zUp.setActionCommand("z_up");
        this.zUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.zUpMouseClicked(evt);
            }
        });
        this.zDown.setFont(new Font("Tahoma", 0, 24));
        this.zDown.setText("Z-");
        this.zDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.zDownMouseClicked(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 0, 18));
        this.jLabel3.setText("XY Step Size");
        this.jLabel4.setFont(new Font("Tahoma", 0, 18));
        this.jLabel4.setText("Z Step Size");
        this.jLabel4.setToolTipText("");
        this.xyStep.setFont(new Font("Tahoma", 0, 18));
        this.xyStep.setText("0.5");
        this.xyStep.setToolTipText("");
        this.zStep.setFont(new Font("Tahoma", 0, 18));
        this.zStep.setText("0.1");
        this.resetZero.setFont(new Font("Tahoma", 0, 18));
        this.resetZero.setText("Reset Zero");
        this.resetZero.setToolTipText("");
        this.resetZero.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.resetZeroMouseClicked(evt);
            }
        });
        this.clearAlarm.setFont(new Font("Tahoma", 0, 18));
        this.clearAlarm.setText("Clear Alarms");
        this.clearAlarm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.clearAlarmMouseClicked(evt);
            }
        });
        this.inRadio.setFont(new Font("Tahoma", 0, 18));
        this.inRadio.setSelected(true);
        this.inRadio.setText("in");
        this.inRadio.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.inRadioMouseClicked(evt);
            }
        });
        this.mmRadio.setFont(new Font("Tahoma", 0, 18));
        this.mmRadio.setText("mm");
        this.mmRadio.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.mmRadioMouseClicked(evt);
            }
        });
        this.jLabel11.setFont(new Font("Tahoma", 0, 18));
        this.jLabel11.setText("Feed rate");
        this.feedRate.setFont(new Font("Tahoma", 0, 18));
        this.feedRate.setText("1000");
        this.feedRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.feedRateActionPerformed(evt);
            }
        });
        this.settings.setText("settings");
        this.settings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.settingsMouseClicked(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(31, 31, 31).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resetZero, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGap(108, 108, 108).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.yDown, -2, 80, -2).addComponent(this.yUp, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.xRight, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.zDown, -2, 71, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.zUp, -2, 71, -2)))).addComponent(this.clearAlarm, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGap(116, 116, 116).addComponent(this.inRadio).addGap(18, 18, 18).addComponent(this.mmRadio)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.xLeft, -2, 74, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel11).addComponent(this.jLabel3)).addGap(17, 17, 17).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xyStep).addComponent(this.zStep).addComponent(this.feedRate)))).addGap(32, 32, 32)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.settings).addGap(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.yUp).addGap(4, 4, 4)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.zUp)).addComponent(this.settings)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yDown).addComponent(this.xLeft).addComponent(this.xRight, -1, -1, Short.MAX_VALUE).addComponent(this.zDown)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xyStep, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.zStep, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.feedRate, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inRadio).addComponent(this.mmRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetZero).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearAlarm).addGap(43, 43, 43)));
        this.gcodeInput.setFont(new Font("Tahoma", 0, 18));
        this.gcodeInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.gcodeInputActionPerformed(evt);
            }
        });
        this.sendGcode.setFont(new Font("Tahoma", 0, 18));
        this.sendGcode.setText("Send");
        this.sendGcode.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.sendGcodeMouseClicked(evt);
            }
        });
        this.connect.setFont(new Font("Tahoma", 0, 18));
        this.connect.setText("Connect");
        this.connect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.connectMouseClicked(evt);
            }
        });
        this.jLabel5.setFont(new Font("Tahoma", 0, 24));
        this.jLabel5.setText("2)");
        this.setHeight.setFont(new Font("Tahoma", 0, 18));
        this.setHeight.setText("Move to height setting location");
        this.setHeight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.setHeightMouseClicked(evt);
            }
        });
        this.setHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.setHeightActionPerformed(evt);
            }
        });
        this.jLabel6.setFont(new Font("Tahoma", 0, 24));
        this.jLabel6.setText("4)");
        this.home.setFont(new Font("Tahoma", 0, 18));
        this.home.setText("Home CuScribe");
        this.home.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.homeMouseClicked(evt);
            }
        });
        this.start.setFont(new Font("Tahoma", 0, 18));
        this.start.setText("Print");
        this.start.setActionCommand("Start");
        this.start.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.startMouseClicked(evt);
            }
        });
        this.pause.setFont(new Font("Tahoma", 0, 18));
        this.pause.setText("Pause");
        this.pause.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.pauseMouseClicked(evt);
            }
        });
        this.cancel.setFont(new Font("Tahoma", 0, 18));
        this.cancel.setText("Cancel");
        this.cancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.cancelMouseClicked(evt);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.cancelActionPerformed(evt);
            }
        });
        this.jLabel9.setFont(new Font("Tahoma", 2, 18));
        this.jLabel9.setText("<- Only for circuit board printing");
        this.jLabel10.setFont(new Font("Tahoma", 0, 24));
        this.jLabel10.setText("5)");
        this.load.setFont(new Font("Tahoma", 0, 18));
        this.load.setText("Load Print File");
        this.load.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.loadMouseClicked(evt);
            }
        });
        this.connectLabel.setFont(new Font("Tahoma", 0, 18));
        this.connectLabel.setToolTipText("");
        this.fileLabel.setFont(new Font("Tahoma", 0, 18));
        this.fileLabel.setText("C:\\Users\\Andres\\Documents\\NetBeansProjects\\CuScribe_0_1\\top.gcode");
        this.receivedTextArea.setColumns(20);
        this.receivedTextArea.setFont(new Font("Tahoma", 0, 18));
        this.receivedTextArea.setRows(5);
        this.jScrollPane2.setViewportView(this.receivedTextArea);
        this.positionLabel.setBackground(new Color(0, 0, 0));
        this.positionLabel.setFont(new Font("Tahoma", 0, 18));
        this.positionLabel.setForeground(new Color(51, 255, 51));
        this.positionLabel.setHorizontalAlignment(0);
        this.positionLabel.setText("X: 0.0 Y:0.0 Z:0.0");
        this.positionLabel.setOpaque(true);
        this.calibrate.setFont(new Font("Tahoma", 0, 18));
        this.calibrate.setText("Calibrate");
        this.calibrate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.calibrateMouseClicked(evt);
            }
        });
        this.calibrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.calibrateActionPerformed(evt);
            }
        });
        this.verbose.setFont(new Font("Tahoma", 0, 18));
        this.verbose.setText("Show verbose output");
        this.jLabel12.setFont(new Font("Tahoma", 0, 24));
        this.jLabel12.setText("1)");
        this.jLabel13.setFont(new Font("Tahoma", 0, 24));
        this.jLabel13.setText("3)");
        this.jLabel14.setFont(new Font("Tahoma", 0, 18));
        this.jLabel14.setText("  Lift spindle arm, and mount cutting bit");
        this.jLabel15.setFont(new Font("Tahoma", 0, 18));
        this.jLabel15.setText("  Lower arm and set cut height");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 1226, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serialDropdown, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refresh, -2, 163, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connect, -2, 154, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.connectLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.home, -2, 231, -2).addComponent(this.fileLabel).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.load, -2, 193, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.start, -2, 137, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pause, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancel, -2, 154, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.setHeight, -2, 444, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9, -2, 270, -2)).addComponent(this.jLabel15, -2, 270, -2).addComponent(this.jLabel14, -2, 356, -2))).addComponent(this.jLabel2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.verbose).addGroup(jPanel1Layout.createSequentialGroup().addGap(487, 487, 487).addComponent(this.jLabel7).addGap(44, 44, 44).addComponent(this.jLabel8)).addComponent(this.gcodeInput, -2, 772, -2)).addGap(0, 0, Short.MAX_VALUE))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.positionLabel, -2, 318, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calibrate, -2, 102, -2)))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.sendGcode, -2, 429, -2))))).addGap(20, 20, 20)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(62, 62, 62).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.refresh, -2, 32, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serialDropdown, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel1)).addComponent(this.connectLabel, -1, -1, Short.MAX_VALUE).addComponent(this.connect, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setHeight).addComponent(this.jLabel5).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.home).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.load).addComponent(this.start).addComponent(this.pause, -1, -1, Short.MAX_VALUE).addComponent(this.cancel, -2, 33, -2)))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.calibrate, -1, -1, Short.MAX_VALUE).addComponent(this.positionLabel, -1, 58, Short.MAX_VALUE)).addGap(18, 18, 18)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fileLabel).addGap(18, 18, 18))).addComponent(this.verbose).addGap(5, 5, 5))).addComponent(this.jScrollPane2, -2, 225, -2).addGap(32, 32, 32).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gcodeInput, -2, 42, -2).addComponent(this.sendGcode, -2, 39, -2)).addContainerGap(54, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 1330, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 902, Short.MAX_VALUE));
        this.pack();
    }

    private void yDownActionPerformed(ActionEvent evt) {
    }

    private void setHeightActionPerformed(ActionEvent evt) {
    }

    private void gcodeInputActionPerformed(ActionEvent evt) {
    }

    private void refreshMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.updateSerialPorts();
    }

    private void connectMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        try {
            this.setWait();
            this.s.connect(this.ports[this.serialDropdown.getSelectedIndex()]);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            JOptionPane.showMessageDialog(null, "Failed to connect.");
            this.stopWait();
        }
    }

    public void disconnect() {
        try {
            this.setWait();
            this.s.connect(this.ports[this.serialDropdown.getSelectedIndex()]);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            JOptionPane.showMessageDialog(null, "Failed to connect.");
            this.stopWait();
        }
    }

    public void setPositionLabel(String mess) {
        this.positionLabel.setText(mess);
    }

    private void loadMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        System.out.println(System.getProperty("user.dir") + "\\print_files");
        JFileChooser jfc = new JFileChooser(System.getProperty("user.dir") + "\\print_files");
        jfc.setSize(1600, 1600);
        int returnValue = jfc.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = jfc.getSelectedFile();
            this.fileLabel.setText(selectedFile.getAbsolutePath());
        }
    }

    private void sendGcodeMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.s.command = this.s.sendGcodeCommand;
        this.s.commandPending = true;
    }

    public void setPrintingButtons() {
        this.pause.setEnabled(true);
        this.cancel.setEnabled(true);
    }

    public String getGcodeInput() {
        return this.gcodeInput.getText();
    }

    private void homeMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.s.command = this.s.homeCommand;
        this.s.commandPending = true;
    }

    private void cancelActionPerformed(ActionEvent evt) {
    }

    private void startMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue() && !this.s.pause) {
            return;
        }
        if (this.s.pause) {
            this.s.pause = !this.s.pause;
            this.start.setEnabled(false);
            return;
        }
        this.load.enableInputMethods(false);
        JButton startConfirm = new JButton();
        int dialogResult = JOptionPane.showConfirmDialog(null, "Turn on spindle and vacuum before continuing. Continue?", "Warning", 0);
        if (dialogResult != 0) {
            return;
        }
        this.s.command = this.s.sendFileCommand;
        this.s.commandPending = true;
    }

    private void pauseMouseClicked(MouseEvent evt) {
        this.s.pause = true;
        this.start.setEnabled(true);
    }

    private void cancelMouseClicked(MouseEvent evt) {
        this.s.cancel = true;
    }

    public boolean getVerbose() {
        return this.verbose.isSelected();
    }

    private void setHeightMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.s.command = this.s.setHeightCommand;
        this.s.commandPending = true;
    }

    public String getJogCommand() {
        return this.jogCommand;
    }

    private String cleanNumber(String number) {
        if ((number = number.replaceAll("[^\\d.]", "")).startsWith(".")) {
            number = "0" + number;
        }
        return number;
    }

    private void buildJogCommand(String move) {
        String units = "G20";
        if (this.mmRadio.isSelected()) {
            units = "G21";
        }
        String feed = this.cleanNumber(this.feedRate.getText());
        this.jogCommand = units + "G91G1" + move + "F" + feed;
    }

    private void yUpMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.buildJogCommand("Y" + this.cleanNumber(this.xyStep.getText()));
        this.s.command = this.s.jogCommand;
        this.s.commandPending = true;
    }

    private void xLeftMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.buildJogCommand("X-" + this.cleanNumber(this.xyStep.getText()));
        this.s.command = this.s.jogCommand;
        this.s.commandPending = true;
    }

    private void yDownMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.buildJogCommand("Y-" + this.cleanNumber(this.xyStep.getText()));
        this.s.command = this.s.jogCommand;
        this.s.commandPending = true;
    }

    private void xRightMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.buildJogCommand("X" + this.cleanNumber(this.xyStep.getText()));
        this.s.command = this.s.jogCommand;
        this.s.commandPending = true;
    }

    private void zUpMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.buildJogCommand("Z" + this.cleanNumber(this.zStep.getText()));
        this.s.command = this.s.jogCommand;
        this.s.commandPending = true;
    }

    private void zDownMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.buildJogCommand("Z-" + this.cleanNumber(this.zStep.getText()));
        this.s.command = this.s.jogCommand;
        this.s.commandPending = true;
    }

    private void resetZeroMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.s.command = this.s.resetZeroCommand;
        this.s.commandPending = true;
    }

    private void clearAlarmMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        this.setWait();
        this.s.command = this.s.clearAlarmCommand;
        this.s.commandPending = true;
    }

    private void calibrateActionPerformed(ActionEvent evt) {
    }

    private void calibrateMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        int dialogResult = JOptionPane.showConfirmDialog(null, "WARNING: Do not calibrate before watching calibration tutorial video. Continue?", "Warning", 0);
        if (dialogResult == 0) {
            this.s.command = this.s.calibrateCommand;
            this.s.commandPending = true;
        } else {
            this.stopWait();
            this.s.commandPending = false;
        }
    }

    public void calibrateStep2() {
        int dialogResult = JOptionPane.showConfirmDialog(null, "Before continuing disengage Y axis and move spindle manually to probing location. Continue?", "Warning", 0);
        if (dialogResult == 0) {
            this.s.command = this.s.probeCommand;
            this.s.commandPending = true;
        } else {
            this.stopWait();
            this.s.commandPending = false;
        }
    }

    private void inRadioMouseClicked(MouseEvent evt) {
        this.mmRadio.setSelected(false);
        this.inRadio.setSelected(true);
    }

    private void mmRadioMouseClicked(MouseEvent evt) {
        this.inRadio.setSelected(false);
        this.mmRadio.setSelected(true);
    }

    private void feedRateActionPerformed(ActionEvent evt) {
    }

    private void settingsMouseClicked(MouseEvent evt) {
        if (!this.enableScreen.booleanValue()) {
            return;
        }
        JFileChooser jfc = new JFileChooser(System.getProperty("user.dir"));
        jfc.setSize(1600, 1600);
        int returnValue = jfc.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = jfc.getSelectedFile();
            this.settingsFile = selectedFile.getAbsolutePath();
            this.s.command = this.s.settingsUpdateCommand;
            this.s.commandPending = true;
        }
    }

    public String getFileLocation() {
        return this.fileLabel.getText();
    }

    public void setConnectButtonText(String text) {
        this.connect.setText(text);
        if (text == "Disconnect") {
            this.connectLabel.setText("Connected");
        } else {
            this.connectLabel.setText("Disconnected");
        }
    }

    public void setConnectLabelText(String text) {
        this.connectLabel.setText(text);
    }

    public void setWait() {
        this.setPanelEnabled(this.jPanel1, false);
        this.enableScreen = false;
    }

    public void stopWait() {
        this.setPanelEnabled(this.jPanel1, true);
        this.enableScreen = true;
    }

    void setPanelEnabled(JPanel panel, Boolean isEnabled) {
        if (!isEnabled.booleanValue()) {
            this.jPanel1.setCursor(Cursor.getPredefinedCursor(3));
            this.rootPane.setCursor(Cursor.getPredefinedCursor(3));
            this.receivedTextArea.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.jPanel1.setCursor(Cursor.getPredefinedCursor(0));
            this.rootPane.setCursor(Cursor.getPredefinedCursor(0));
            this.receivedTextArea.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (!Serial.connected.booleanValue()) {
            this.toggleButtons(false);
            this.setDisconnectedButtons();
        } else {
            this.toggleButtons(isEnabled);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }

    private void updateSerialPorts() {
        this.serialDropdown.removeAllItems();
        this.ports = SerialPort.getCommPorts();
        for (int i = 0; i < this.ports.length; ++i) {
            this.serialDropdown.addItem(this.ports[i].getSystemPortName());
        }
    }

    public void toggleButtons(boolean enable) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setEnabled(enable);
        }
    }

    public void setDisconnectedButtons() {
        this.refresh.setEnabled(true);
        this.connect.setEnabled(true);
    }

    private void addButtonsToList() {
        this.buttons.add(this.cancel);
        this.buttons.add(this.clearAlarm);
        this.buttons.add(this.connect);
        this.buttons.add(this.home);
        this.buttons.add(this.load);
        this.buttons.add(this.pause);
        this.buttons.add(this.refresh);
        this.buttons.add(this.resetZero);
        this.buttons.add(this.sendGcode);
        this.buttons.add(this.setHeight);
        this.buttons.add(this.start);
        this.buttons.add(this.xLeft);
        this.buttons.add(this.xRight);
        this.buttons.add(this.yDown);
        this.buttons.add(this.yUp);
        this.buttons.add(this.zDown);
        this.buttons.add(this.zUp);
        this.buttons.add(this.calibrate);
        this.buttons.add(this.settings);
    }
}

